<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

class TenantPaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Switch to tenant connection
        $tenantDatabase = config('database.connections.tenant.database');
        
        // Configure Stripe (test mode)
        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'payment_gateway'],
            [
                'value' => 'stripe',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        // Stripe test keys (you should update these with real test keys)
        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'payment_key'],
            [
                'value' => 'pk_test_51234567890abcdef', // Replace with actual Stripe test key
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'payment_secret'],
            [
                'value' => 'sk_test_51234567890abcdef', // Replace with actual Stripe test secret
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        // Enable Stripe sandbox mode
        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'stripe_sandbox'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        // Configure SSLCommerz (test mode)
        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'sslcommerz_store_id'],
            [
                'value' => 'test123',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'sslcommerz_store_password'],
            [
                'value' => 'test123',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'sslcommerz_sandbox'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        // Enable manual payment gateways
        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'enable_bkash_manual'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'bkash_number'],
            [
                'value' => '01312345678',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'bkash_type'],
            [
                'value' => 'personal',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'enable_nagad_manual'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'nagad_number'],
            [
                'value' => '01312345678',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'nagad_type'],
            [
                'value' => 'personal',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'enable_rocket_manual'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'rocket_number'],
            [
                'value' => '01312345678',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        DB::connection('tenant')->table('app_settings')->updateOrInsert(
            ['key' => 'rocket_type'],
            [
                'value' => 'personal',
                'group' => 'payment',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        $this->command->info('Tenant payment gateway settings configured successfully!');
    }
}
