<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // create permissions
        $permissions = [
            'view-reports',
            'manage-all',
            'use-pos',
            'view-stock',
            'return-entry',
            'create-data',
            'update-data',
            'delete-data',
            'manage-tenants',
            'manage-plans',
            'manage-users',
            'manage-roles',
            'manage-settings',
            'developer.dashboard.view',
            'developer.tenants.view',
            'developer.tenants.activity',
            'developer.tenants.applications',
            'developer.database.view',
            'developer.logs.view',
            'developer.accounts.create',
            'developer.roles.manage',
            'developer.tenants.subscription.assign',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // create roles
        $roles = [
            'Admin',
            'Developer',
            'Manager',
            'Account',
            'Staff',
            'Front Desk',
            'Customer',
            'Guest',
            'User' // Added User role
        ];

        foreach ($roles as $roleName) {
            $role = Role::firstOrCreate(['name' => $roleName, 'guard_name' => 'web']);
            
            // Assign permissions to roles
            if ($roleName === 'Manager' || $roleName === 'Admin' || $roleName === 'Developer') {
                $role->syncPermissions(Permission::all());
            } elseif ($roleName === 'Staff') {
                $role->syncPermissions([
                    'view-reports',
                    'use-pos',
                    'view-stock',
                    'return-entry',
                    'create-data',
                    'update-data',
                ]);
            } elseif ($roleName === 'User') {
                $role->syncPermissions([
                    'use-pos',
                    'view-stock',
                    'return-entry',
                    'create-data',
                ]);
            } elseif ($roleName === 'Guest') {
                $role->syncPermissions([
                    'view-reports',
                    'view-stock',
                ]);
            }
        }
    }
}
