<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Plan;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Basic',
                'slug' => 'basic-monthly',
                'price' => 29.00,
                'interval' => 'monthly',
                'features' => ['max_products' => 100, 'max_users' => 2],
            ],
            [
                'name' => 'Pro',
                'slug' => 'pro-monthly',
                'price' => 79.00,
                'interval' => 'monthly',
                'features' => ['max_products' => 1000, 'max_users' => 10],
            ],
            [
                'name' => 'Enterprise',
                'slug' => 'enterprise-yearly',
                'price' => 999.00,
                'interval' => 'yearly',
                'features' => ['max_products' => -1, 'max_users' => -1],
            ],
        ];

        foreach ($plans as $plan) {
            Plan::firstOrCreate(['slug' => $plan['slug']], $plan);
        }
    }
}
