<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AppSetting;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Configure Stripe (test mode)
        AppSetting::updateOrCreate(
            ['key' => 'payment_gateway'],
            [
                'value' => 'stripe',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        // Stripe test keys (you should update these with real test keys)
        AppSetting::updateOrCreate(
            ['key' => 'payment_key'],
            [
                'value' => 'pk_test_51234567890abcdef', // Replace with actual Stripe test key
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'payment_secret'],
            [
                'value' => 'sk_test_51234567890abcdef', // Replace with actual Stripe test secret
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        // Enable Stripe sandbox mode
        AppSetting::updateOrCreate(
            ['key' => 'stripe_sandbox'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean'
            ]
        );

        // Configure SSLCommerz (test mode)
        AppSetting::updateOrCreate(
            ['key' => 'sslcommerz_store_id'],
            [
                'value' => 'test123',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'sslcommerz_store_password'],
            [
                'value' => 'test123',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'sslcommerz_sandbox'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean'
            ]
        );

        // Enable manual payment gateways
        AppSetting::updateOrCreate(
            ['key' => 'enable_bkash_manual'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'bkash_number'],
            [
                'value' => '01312345678',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'bkash_type'],
            [
                'value' => 'personal',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'enable_nagad_manual'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'nagad_number'],
            [
                'value' => '01312345678',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'nagad_type'],
            [
                'value' => 'personal',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'enable_rocket_manual'],
            [
                'value' => 'true',
                'group' => 'payment',
                'type' => 'boolean'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'rocket_number'],
            [
                'value' => '01312345678',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        AppSetting::updateOrCreate(
            ['key' => 'rocket_type'],
            [
                'value' => 'personal',
                'group' => 'payment',
                'type' => 'string'
            ]
        );

        $this->command->info('Payment gateway settings configured successfully!');
    }
}
