<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Spatie\Permission\Models\Role;

class DeveloperSeeder extends Seeder
{
    public function run()
    {
        // Ensure Developer role exists (it should be created by RolesAndPermissionsSeeder)
        $developerRole = Role::where('name', 'Developer')->first();
        
        if (!$developerRole) {
            $this->command->error('Developer role not found. Please run RolesAndPermissionsSeeder first.');
            return;
        }

        // Create developer user
        $developerUser = User::firstOrCreate(['email' => 'dev@example.com'], [
            'name' => 'Developer User',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'status' => 'active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Assign Developer role to user
        $developerUser->syncRoles(['Developer']);

        $this->command->info('Developer user created/updated successfully!');
        $this->command->info('Email: dev@example.com');
        $this->command->info('Password: password');
    }
}
