<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            RolesAndPermissionsSeeder::class,
            PlanSeeder::class,
            SubscriptionSeeder::class,
            PaymentGatewaySeeder::class,
        ]);
        
        // Create SaaS Admin
        $admin = User::firstOrCreate(
            ['email' => 'admin@grocery-saas.com'],
            [
                'name' => 'SaaS Admin',
                'password' => Hash::make('password'),
                'status' => 'active',
                'tenant_id' => null, // Central admin
            ]
        );
        $admin->assignRole('Admin');
    }
}
