<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AdminNotification;
use App\Models\User;

class AdminNotificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get admin user
        $admin = User::where('email', 'admin@grocery-saas.com')->first();
        
        if (!$admin) {
            $this->command->error('Admin user not found. Please run the main seeder first.');
            return;
        }

        // Create some demo notifications
        $notifications = [
            [
                'title' => 'Welcome to Grocery SaaS!',
                'message' => 'Thank you for joining our platform. Start managing your inventory efficiently.',
                'type' => 'info',
                'target_type' => 'all',
                'target_id' => null,
                'sent_by' => $admin->id,
                'is_read' => false,
                'sent_at' => now(),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'New Feature Available',
                'message' => 'Check out our new POS system with variant support. Click Products in the menu to get started.',
                'type' => 'success',
                'target_type' => 'all',
                'target_id' => null,
                'sent_by' => $admin->id,
                'is_read' => false,
                'sent_at' => now()->subHours(2),
                'created_at' => now()->subHours(2),
                'updated_at' => now()->subHours(2),
            ],
            [
                'title' => 'Payment Gateway Setup',
                'message' => 'Payment gateways have been configured. You can now purchase subscriptions from the Plans page.',
                'type' => 'success',
                'target_type' => 'all',
                'target_id' => null,
                'sent_by' => $admin->id,
                'is_read' => false,
                'sent_at' => now()->subDay(),
                'created_at' => now()->subDay(),
                'updated_at' => now()->subDay(),
            ],
        ];

        foreach ($notifications as $notification) {
            AdminNotification::create($notification);
        }

        $this->command->info('Admin notifications seeded successfully!');
    }
}
