<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            // Rename total to total_amount if total exists and total_amount doesn't
            if (Schema::hasColumn('purchases', 'total') && !Schema::hasColumn('purchases', 'total_amount')) {
                $table->renameColumn('total', 'total_amount');
            } elseif (!Schema::hasColumn('purchases', 'total_amount')) {
                $table->decimal('total_amount', 15, 2)->default(0)->after('supplier_id');
            }

            // Ensure supplier_id is nullable
            $table->foreignId('supplier_id')->nullable()->change();
        });

        Schema::table('purchase_items', function (Blueprint $table) {
            // Ensure location_id exists
            if (!Schema::hasColumn('purchase_items', 'location_id')) {
                $table->foreignId('location_id')->nullable()->after('unit_id')->constrained('store_locations')->onDelete('set null');
            }
            
            // Ensure total exists (rename cost*quantity if needed or just add)
            if (!Schema::hasColumn('purchase_items', 'total')) {
                $table->decimal('total', 15, 2)->default(0)->after('unit_cost');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            if (Schema::hasColumn('purchases', 'total_amount')) {
                $table->renameColumn('total_amount', 'total');
            }
        });

        Schema::table('purchase_items', function (Blueprint $table) {
            $table->dropForeign(['location_id']);
            $table->dropColumn(['location_id']);
        });
    }
};
