<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            // Ensure purchase_no exists first if it was missing from early migrations
            if (!Schema::hasColumn('purchases', 'purchase_no')) {
                $table->string('purchase_no')->unique()->nullable()->after('id');
            }
            
            if (!Schema::hasColumn('purchases', 'mrr_no')) {
                $table->string('mrr_no')->nullable()->after('purchase_no');
            }
            if (!Schema::hasColumn('purchases', 'challan_no')) {
                $table->string('challan_no')->nullable()->after('mrr_no');
            }
            if (!Schema::hasColumn('purchases', 'notes')) {
                $table->text('notes')->nullable()->after('status');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            $table->dropColumn(['purchase_no', 'mrr_no', 'challan_no']);
        });
    }
};
