<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Create Sale Returns Tables
        Schema::create('sale_returns', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_id')->nullable()->constrained()->onDelete('set null');
            $table->string('return_no')->unique(); // RET-20240129-XXXX
            $table->foreignId('customer_id')->nullable()->constrained()->onDelete('set null');
            $table->decimal('total_amount', 10, 2);
            $table->text('note')->nullable();
            $table->timestamps();
        });

        Schema::create('sale_return_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_return_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_variant_id')->constrained('product_variants')->onDelete('cascade');
            $table->foreignId('product_unit_id')->nullable()->constrained('product_units')->onDelete('set null');
            $table->decimal('conversion_factor', 10, 4)->default(1);
            $table->decimal('quantity', 10, 4);
            $table->decimal('unit_price', 10, 2); // Price at which it was returned (usually sold price)
            $table->decimal('total', 10, 2);
            $table->timestamps();
        });

        // 2. Add Discount Columns to Sale Items
        Schema::table('sale_items', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_items', 'discount_type')) {
                $table->string('discount_type')->default('none')->after('price'); // none, fixed, percent
            }
            if (!Schema::hasColumn('sale_items', 'discount_value')) {
                $table->decimal('discount_value', 10, 2)->default(0)->after('discount_type');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sale_items', function (Blueprint $table) {
            $table->dropColumn(['discount_type', 'discount_value']);
        });

        Schema::dropIfExists('sale_return_items');
        Schema::dropIfExists('sale_returns');
    }
};
