<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Create product_units table - SKIPPED (Already exists in 2026_01_29_110000)
        // Schema::create('product_units', function (Blueprint $table) { ... });

        // 2. Add unit tracking to sale_items
        Schema::table('sale_items', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_items', 'product_unit_id')) {
                $table->foreignId('product_unit_id')->nullable()->after('variant_id')->constrained('product_units')->onDelete('set null');
            }
            if (!Schema::hasColumn('sale_items', 'conversion_factor')) {
                $table->decimal('conversion_factor', 10, 4)->default(1)->after('product_unit_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sale_items', function (Blueprint $table) {
            $table->dropForeign(['product_unit_id']);
            $table->dropColumn(['product_unit_id', 'conversion_factor']);
        });
    }
};
