<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            if (!Schema::hasColumn('sales', 'invoice_no')) {
                $table->string('invoice_no')->unique()->nullable()->after('id');
            }
        });
        
        // Populate existing sales with an invoice number if needed
        // DB::statement("UPDATE sales SET invoice_no = CONCAT('INV-', id) WHERE invoice_no IS NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn('invoice_no');
        });
    }
};
