<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // We removed the 'users' foreign key constraint because users table is usually in the central database,
        // or if it exists in tenant, it might be named differently or not available at this point.
        // For simplicity in this tenant context, we'll store the ID but not enforce FK constraint if 'users' doesn't exist.

        if (!Schema::hasTable('purchase_requisitions')) {
            Schema::create('purchase_requisitions', function (Blueprint $table) {
                $table->id();
                $table->string('requisition_no')->unique(); // Unique PR Number
                $table->foreignId('supplier_id')->nullable()->constrained('suppliers')->onDelete('set null');
                $table->decimal('total_amount', 10, 2)->default(0);
                $table->string('status')->default('pending'); // pending, approved, ordered, received, cancelled
                $table->text('note')->nullable();
                $table->unsignedBigInteger('created_by'); // User ID without strict FK for now
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('purchase_requisition_items')) {
            Schema::create('purchase_requisition_items', function (Blueprint $table) {
                $table->id();
                $table->foreignId('purchase_requisition_id')->constrained()->onDelete('cascade');
                $table->foreignId('product_variant_id')->constrained('product_variants');
                $table->decimal('quantity', 10, 2);
                $table->decimal('cost_price', 10, 2); // Expected cost
                $table->decimal('total', 10, 2);
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('purchases')) {
            Schema::create('purchases', function (Blueprint $table) {
                $table->id();
                $table->string('purchase_no')->unique();
                $table->foreignId('purchase_requisition_id')->nullable()->constrained()->onDelete('set null'); // Linked to PR
                $table->foreignId('supplier_id')->constrained();
                $table->decimal('total_amount', 10, 2);
                $table->decimal('paid_amount', 10, 2)->default(0);
                $table->string('status')->default('received'); // received, partial
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('purchase_items')) {
            Schema::create('purchase_items', function (Blueprint $table) {
                $table->id();
                $table->foreignId('purchase_id')->constrained()->onDelete('cascade');
                $table->foreignId('product_variant_id')->constrained('product_variants');
                $table->decimal('quantity', 10, 2);
                $table->decimal('unit_cost', 10, 2);
                $table->decimal('total', 10, 2);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_items');
        Schema::dropIfExists('purchases');
        Schema::dropIfExists('purchase_requisition_items');
        Schema::dropIfExists('purchase_requisitions');
    }
};
