<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('manufacturers', function (Blueprint $table) {
            $table->text('address')->nullable()->after('image');
            $table->string('contact_no')->nullable()->after('address');
            $table->string('contact_person')->nullable()->after('contact_no');
            $table->decimal('opening_balance', 10, 2)->default(0)->after('contact_person'); // Dui / closing Summary (Initial)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('manufacturers', function (Blueprint $table) {
            $table->dropColumn(['address', 'contact_no', 'contact_person', 'opening_balance']);
        });
    }
};
