<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->string('image')->nullable()->after('name');
            $table->text('address')->nullable()->after('email');
            $table->boolean('is_active')->default(true)->after('contact');
            $table->boolean('allow_credit')->default(false)->after('is_active'); // is enable for due purchase
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn(['image', 'address', 'is_active', 'allow_credit']);
        });
    }
};
