<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->string('payment_gateway')->nullable()->after('trial_ends_at');
            $table->string('transaction_id')->nullable()->after('payment_gateway');
            $table->decimal('amount', 10, 2)->nullable()->after('transaction_id');
            $table->string('currency', 10)->default('USD')->after('amount');
            $table->string('payment_status')->default('pending')->after('currency');
            $table->timestamp('verified_at')->nullable()->after('payment_status');
            $table->timestamp('refunded_at')->nullable()->after('verified_at');
            $table->text('refund_reason')->nullable()->after('refunded_at');
            $table->decimal('refund_amount', 10, 2)->nullable()->after('refund_reason');
            $table->string('refund_id')->nullable()->after('refund_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropColumn([
                'payment_gateway',
                'transaction_id',
                'amount',
                'currency',
                'payment_status',
                'verified_at',
                'refunded_at',
                'refund_reason',
                'refund_amount',
                'refund_id'
            ]);
        });
    }
};
