<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('security_settings', function (Blueprint $table) {
            $table->id();
            $table->boolean('enable_captcha')->default(false);
            $table->boolean('enable_2fa')->default(false); // 3D Verification
            $table->boolean('enable_ip_blocking')->default(false);
            $table->boolean('enable_honeypot')->default(false);
            $table->boolean('enable_login_log')->default(false);
            $table->boolean('enable_data_backup')->default(false);
            $table->boolean('enable_maintenance_mode')->default(false); // Site Mange Flag
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('security_settings');
    }
};
