# Technical Documentation: Complex Product Variants

## 1. Overview
The system now supports creating products with multiple variations (e.g., Size, Color) and multiple units of measure (e.g., Piece, Case, Pack). This allows for precise inventory tracking and flexible pricing.

## 2. Key Features

### A. Multi-Unit Management
- **Base Unit**: The fundamental unit of tracking (e.g., "Piece").
- **Custom Units**: Additional units defined per product (e.g., "Case = 24 Pieces").
- **Conversion**: The system automatically calculates stock and prices based on conversion factors.

### B. Dynamic Variants
- **Attributes**: Users can define any number of attributes (Type, Size, Color).
- **Matrix Generation**: The system automatically generates all possible combinations (Cartesian product) of the defined attributes.
- **SKU Generation**: SKUs are auto-generated but can be customized.

### C. Advanced Pricing
- **Per-Unit Pricing**: Each variant can have a specific price for every defined unit.
  - *Example*: A single Pepsi Can cost $0.50, but a Case (24) costs $10.00 (bulk discount).
- **Cost Tracking**: Cost prices can also be set per unit for accurate profit calculation.

## 3. Data Structure

### Database Schema
- `products`: Main entity, holds `has_variants` flag and global `unit_id`.
- `product_units`: Stores product-specific units (e.g., Case) and a wrapper for the Base Unit.
- `product_variants`: Stores specific SKUs (e.g., Pepsi-Can-250ml).
- `variant_attributes`: Stores the attribute values (e.g., Type=Can).
- `variant_prices`: Stores the price/cost for a specific Variant + Unit combination.

## 4. Usage Guide (Pepsi Example)

1.  **Create Product**: Name "Pepsi", Base Unit "Piece".
2.  **Toggle Variants**: Enable "Multiple options".
3.  **Define Attributes**:
    - Type: Can, Bottle
    - Size: 250ml, 1L
4.  **Define Units**:
    - Case (24)
5.  **Generate Variants**: System creates 4 rows (Can/250, Can/1L, Bottle/250, Bottle/1L).
6.  **Set Prices**:
    - For "Can/250": Set Piece Price $0.50, Case Price $10.00.
7.  **Save**: The product is now available for purchase in both single cans and cases.
