<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->append(\App\Http\Middleware\CheckBlockedIp::class);
        $middleware->append(\App\Http\Middleware\RequestMonitorMiddleware::class);

        $middleware->web(append: [
            \App\Http\Middleware\CheckHoneypot::class,
        ]);

        $middleware->alias([
            'tenant' => \App\Http\Middleware\TenantResolver::class,
            'tenant.context' => \App\Http\Middleware\SetupTenantContext::class,
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
            '2fa' => \App\Http\Middleware\CheckTwoFactor::class,
            'tenant.subscription' => \App\Http\Middleware\EnforceTenantSubscription::class,
            'developer' => \App\Http\Middleware\DeveloperMiddleware::class,
        ]);
        
        $middleware->api(append: [
            \App\Http\Middleware\LogActivity::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
