<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Failed;
use App\Listeners\LogSuccessfulLogin;
use App\Listeners\LogFailedLogin;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use App\Models\AppSetting;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Event::listen(Login::class, LogSuccessfulLogin::class);
        Event::listen(Failed::class, LogFailedLogin::class);

        // Load Dynamic Settings
        try {
            if (Schema::hasTable('app_settings')) {
                $settings = AppSetting::all()->pluck('value', 'key');
                
                // SSLCommerz Configuration
                if (isset($settings['enable_sslcommerz']) && $settings['enable_sslcommerz']) {
                    if (isset($settings['sslcommerz_store_id'])) {
                        Config::set('sslcommerz.store.id', $settings['sslcommerz_store_id']);
                    }
                    if (isset($settings['sslcommerz_store_password'])) {
                        Config::set('sslcommerz.store.password', $settings['sslcommerz_store_password']);
                    }
                    if (isset($settings['sslcommerz_sandbox'])) {
                        Config::set('sslcommerz.sandbox', (bool)$settings['sslcommerz_sandbox']);
                    }
                }
            }
        } catch (\Exception $e) {
            // Log or ignore if DB connection fails during boot (e.g. installation)
        }
    }
}
