<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TenantCategory extends Model
{
    protected $fillable = ['name', 'slug', 'description', 'settings', 'default_categories', 'is_active'];

    protected $casts = [
        'settings' => 'array',
        'default_categories' => 'array',
        'is_active' => 'boolean',
    ];

    public function tenants()
    {
        return $this->hasMany(Tenant::class);
    }

    public function plans()
    {
        return $this->hasMany(Plan::class);
    }
}
