<?php

namespace App\Models\Tenant;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductUnit extends Model
{
    use HasFactory;
    protected $connection = 'tenant';
    protected $guarded = [];
    protected $casts = [
        'is_base' => 'boolean',
        'is_purchase' => 'boolean',
        'is_sale' => 'boolean',
        'conversion_factor' => 'decimal:4',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
