<?php

namespace App\Models\Tenant;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;
    
    // Ensure we use the tenant connection
    protected $connection = 'tenant';

    protected $guarded = [];

    protected $casts = [
        'is_active' => 'boolean',
        'allow_credit' => 'boolean',
        'is_sub_dealer' => 'boolean',
    ];

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }
}
