<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tenant extends Model
{
    use HasFactory;

    protected $connection = 'mysql';

    protected $fillable = [
        'name',
        'domain',
        'database_name',
        'status',
        'trial_ends_at',
        'tenant_category_id',
    ];

    public function category()
    {
        return $this->belongsTo(TenantCategory::class, 'tenant_category_id');
    }

    protected $casts = [
        'trial_ends_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::creating(function ($tenant) {
            if ($tenant->status === 'active' && !$tenant->trial_ends_at) {
                $tenant->trial_ends_at = now()->addDays(15);
            }
        });

        static::updating(function ($tenant) {
            if ($tenant->isDirty('status') && $tenant->status === 'active' && !$tenant->trial_ends_at) {
                $tenant->trial_ends_at = now()->addDays(15);
            }
        });
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function subscription()
    {
        return $this->hasOne(Subscription::class)->latest();
    }
    
    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }
    
    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
}
