<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    protected $connection = 'mysql';

    protected $fillable = [
        'name',
        'slug',
        'type',
        'description',
        'price',
        'interval',
        'is_active',
        'features',
        'tenant_category_id',
    ];

    public function category()
    {
        return $this->belongsTo(TenantCategory::class, 'tenant_category_id');
    }

    protected $casts = [
        'features' => 'array',
        'price' => 'decimal:2',
        'is_active' => 'boolean',
    ];
}
