<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model
{
    use HasFactory;

    protected $connection = 'mysql';

    protected $fillable = [
        'user_id',
        'action',
        'description',
        'ip',
        'user_agent',
    ];
    
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
