<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AdminNotification extends Model
{
    use HasFactory;

    /**
     * The database connection that should be used by the model.
     *
     * @var string
     */
    protected $connection = 'mysql';

    protected $fillable = [
        'title',
        'message',
        'type',
        'target_type', // 'all', 'tenant', 'customer'
        'target_id', // specific tenant or customer ID
        'sent_by', // admin user ID
        'is_read',
        'read_at',
        'sent_at'
    ];

    protected $casts = [
        'is_read' => 'boolean',
        'read_at' => 'datetime',
        'sent_at' => 'datetime',
    ];

    public function sender()
    {
        return $this->belongsTo(User::class, 'sent_by');
    }

    public function scopeUnread($query)
    {
        return $query->where('is_read', false);
    }

    public function scopeForTenant($query, $tenantId)
    {
        return $query->where(function($q) use ($tenantId) {
            $q->where('target_type', 'all')
              ->orWhere('target_type', 'tenant')
              ->orWhere(function($subQuery) use ($tenantId) {
                  $subQuery->where('target_type', 'tenant')
                           ->where('target_id', $tenantId);
              });
        });
    }

    public function markAsRead()
    {
        $this->update([
            'is_read' => true,
            'read_at' => now()
        ]);
    }
}
