<?php

namespace App\Mail;

use App\Models\Tenant;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection; // Import Collection

class ExpiringProductsNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $tenant;
    public $expiringProducts;

    /**
     * Create a new message instance.
     */
    public function __construct(Tenant $tenant, Collection $expiringProducts)
    {
        $this->tenant = $tenant;
        $this->expiringProducts = $expiringProducts;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "{$this->tenant->name} - Products Expiring Soon!",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.expiring-products',
            with: [
                'tenant' => $this->tenant,
                'expiringProducts' => $this->expiringProducts,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
