<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Models\LoginLog;
use App\Models\SecuritySetting;
use Illuminate\Http\Request;

class LogSuccessfulLogin
{
    protected $request;

    /**
     * Create the event listener.
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * Handle the event.
     */
    public function handle(Login $event): void
    {
        $settings = SecuritySetting::first();
        if ($settings && $settings->enable_login_log) {
            LoginLog::create([
                'email' => $event->user->email,
                'ip_address' => $this->request->ip(),
                'user_agent' => $this->request->userAgent(),
                'status' => 'success',
            ]);
        }
    }
}
