<?php

namespace App\Imports\Tenant;

use App\Models\Tenant\ProductVariant;
use App\Models\Tenant\StockMovement;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Facades\DB;

class StockInImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        // Expected columns: sku, quantity, notes
        $sku = $row['sku'] ?? null;
        $quantity = $row['quantity'] ?? 0;
        $notes = $row['notes'] ?? 'Excel Stock In';

        if (!$sku || $quantity <= 0) {
            return null;
        }

        $variant = ProductVariant::where('sku', $sku)->first();

        if (!$variant) {
            // Handle error or skip
            return null;
        }

        DB::transaction(function () use ($variant, $quantity, $notes) {
            $oldStock = $variant->stock;
            $newStock = $oldStock + $quantity;

            // Update variant stock
            $variant->update(['stock' => $newStock]);

            // Record stock movement
            StockMovement::record(
                $variant->id,
                $quantity,
                'purchase',
                'manual',
                null,
                $notes . " (Stock: {$oldStock} → {$newStock})"
            );
        });

        return null; // We return null because we already processed it in the transaction
    }
}
