<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class EnforceTenantSubscription
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        if (!$user || !$user->tenant) {
            return $next($request);
        }

        $tenant = $user->tenant;

        // Check if tenant has an active subscription
        $activeSubscription = $tenant->subscription()->where('ends_at', '>', now())->exists();

        // Check if tenant is in trial period
        $inTrial = $tenant->trial_ends_at && $tenant->trial_ends_at->isFuture();

        // If neither active subscription nor in trial, enforce read-only
        if (!$activeSubscription && !$inTrial) {
            // Allow GET requests (Read-only)
            if ($request->isMethod('GET')) {
                // Share status with view
                view()->share('readOnlyMode', true);
                return $next($request);
            }

            // Allow specific routes for subscription management and logout
            if ($request->routeIs('tenant.subscription.*') || $request->routeIs('tenant.logout')) {
                return $next($request);
            }

            // Block other modification requests
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Your subscription or trial has expired. You are in read-only mode. Please purchase a plan to continue.'], 403);
            }

            return back()->with('error', 'Your subscription or trial has expired. You are in read-only mode. Please purchase a plan to continue.');
        }

        return $next($request);
    }
}
