<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DeveloperMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if user is authenticated
        if (!Auth::check()) {
            return redirect()->route('developer.login')->with('error', 'You must be logged in to access the developer dashboard.');
        }

        // Check if user has developer role
        if (!Auth::user()->hasRole('Developer')) {
            // If user has admin role, show a more specific message
            if (Auth::user()->hasRole('Admin')) {
                return redirect()->route('admin.dashboard')->with('error', 'Access denied. This area is restricted to developers only.');
            }
            
            // For other users, show general message
            return redirect()->route('developer.login')->with('error', 'Access denied. You do not have permission to access the developer dashboard.');
        }

        // Check if user has specific developer permission
        if (!Auth::user()->can('developer.dashboard.view')) {
            return redirect()->route('developer.login')->with('error', 'Access denied. You do not have the required permissions to access the developer dashboard.');
        }

        return $next($request);
    }
}
