<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\SecuritySetting;
use Spatie\Honeypot\ProtectAgainstSpam;

class CheckHoneypot
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Only check on POST/PUT/PATCH methods
        if (!$request->isMethod('POST') && !$request->isMethod('PUT') && !$request->isMethod('PATCH')) {
            return $next($request);
        }

        try {
            $settings = SecuritySetting::first();
            
            if ($settings && $settings->enable_honeypot) {
                // Delegate to the Spatie Honeypot middleware
                return app(ProtectAgainstSpam::class)->handle($request, $next);
            }
        } catch (\Exception $e) {
            // If table doesn't exist or other error, fail open (allow request)
            // or log error. For now, just continue.
        }

        return $next($request);
    }
}
