<?php

namespace App\Http\Controllers\Tenant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tenant\StoreLocation;

class StoreLocationController extends Controller
{
    public function index()
    {
        $locations = StoreLocation::orderBy('name')->paginate(10);
        return view('tenant.inventory.locations.index', compact('locations'));
    }

    public function create()
    {
        return view('tenant.inventory.locations.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:showroom,godown',
            'address' => 'nullable|string',
        ]);
        StoreLocation::create($validated);
        return redirect()->route('tenant.locations.index')->with('success', 'Location created successfully.');
    }

    public function edit($id)
    {
        $location = StoreLocation::on('tenant')->findOrFail($id);
        return view('tenant.inventory.locations.edit', compact('location'));
    }

    public function update(Request $request, $id)
    {
        $location = StoreLocation::on('tenant')->findOrFail($id);
        
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:showroom,godown',
            'address' => 'nullable|string',
        ]);
        $location->update($validated);
        return redirect()->route('tenant.locations.index')->with('success', 'Location updated successfully.');
    }

    public function destroy($id)
    {
        $location = StoreLocation::on('tenant')->findOrFail($id);
        $location->delete();
        return redirect()->route('tenant.locations.index')->with('success', 'Location deleted successfully.');
    }
}
