<?php

namespace App\Http\Controllers\Tenant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tenant\Category;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::with('parent')->orderBy('name')->paginate(10);
        return view('tenant.catalog.categories.index', compact('categories'));
    }

    public function create()
    {
        $parents = Category::whereNull('parent_id')->get();
        return view('tenant.catalog.categories.create', compact('parents'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'parent_id' => 'nullable|exists:tenant.categories,id',
        ]);

        Category::create($validated);
        return redirect()->route('tenant.categories.index')->with('success', 'Category created successfully.');
    }

    public function edit($id)
    {
        $category = Category::on('tenant')->findOrFail($id);
        $parents = Category::on('tenant')->whereNull('parent_id')->where('id', '!=', $category->id)->get();
        return view('tenant.catalog.categories.edit', compact('category', 'parents'));
    }

    public function update(Request $request, $id)
    {
        $category = Category::on('tenant')->findOrFail($id);
        
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'parent_id' => 'nullable|exists:tenant.categories,id',
        ]);

        $category->update($validated);
        return redirect()->route('tenant.categories.index')->with('success', 'Category updated successfully.');
    }

    public function destroy($id)
    {
        $category = Category::on('tenant')->findOrFail($id);
        $category->delete();
        return redirect()->route('tenant.categories.index')->with('success', 'Category deleted successfully.');
    }
}
