<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AppSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class SettingController extends Controller
{
    public function index()
    {
        $settings = AppSetting::all()->pluck('value', 'key');
        return view('admin.settings.index', compact('settings'));
    }

    public function testSerper(Request $request)
    {
        $apiKey = $request->api_key ?? AppSetting::get('api_serper_key');

        if (!$apiKey) {
            return response()->json([
                'success' => false,
                'message' => 'API Key পাওয়া যায়নি। দয়া করে আগে কী (Key) প্রদান করুন।'
            ]);
        }

        try {
            $response = Http::withHeaders([
                'X-API-KEY' => $apiKey,
                'Content-Type' => 'application/json',
            ])->post('https://google.serper.dev/search', [
                'q' => 'Laravel',
                'num' => 1
            ]);

            if ($response->successful()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Serper.dev API সফলভাবে কাজ করছে! ✅',
                    'data' => $response->json()
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'API কাজ করছে না। ত্রুটি: ' . ($response->json()['message'] ?? 'Unknown Error'),
                    'status' => $response->status()
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'কানেকশন ফেইল হয়েছে: ' . $e->getMessage()
            ]);
        }
    }

    public function testRapidAPI(Request $request)
    {
        $apiKey = $request->api_key ?? AppSetting::get('api_rapidapi_key');
        if (!$apiKey) return response()->json(['success' => false, 'message' => 'API Key পাওয়া যায়নি।']);

        try {
            // Testing with a simple free API on RapidAPI (e.g., WordsAPI or similar)
            // For general testing, we just check if we can reach RapidAPI
            $response = Http::withHeaders([
                'X-RapidAPI-Key' => $apiKey,
                'X-RapidAPI-Host' => 'wordsapiv1.p.rapidapi.com'
            ])->get('https://wordsapiv1.p.rapidapi.com/words/laravel');

            if ($response->status() !== 401 && $response->status() !== 403) {
                return response()->json(['success' => true, 'message' => 'RapidAPI কানেকশন সফল! ✅']);
            }
            return response()->json(['success' => false, 'message' => 'RapidAPI কী (Key) ইনভ্যালিড।']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function testOpenRouter(Request $request)
    {
        $apiKey = $request->api_key ?? AppSetting::get('api_openrouter_key');
        if (!$apiKey) return response()->json(['success' => false, 'message' => 'API Key পাওয়া যায়নি।']);

        try {
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $apiKey,
            ])->get('https://openrouter.ai/api/v1/models');

            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'OpenRouter API সফলভাবে কাজ করছে! ✅']);
            }
            return response()->json(['success' => false, 'message' => 'OpenRouter কী (Key) সঠিক নয়।']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function testNumverify(Request $request)
    {
        $apiKey = $request->api_key ?? AppSetting::get('api_numverify_key');
        if (!$apiKey) return response()->json(['success' => false, 'message' => 'API Key পাওয়া যায়নি।']);

        try {
            $response = Http::get('http://apilayer.net/api/validate', [
                'access_key' => $apiKey,
                'number' => '14158586273'
            ]);

            if ($response->successful() && !isset($response->json()['error'])) {
                return response()->json(['success' => true, 'message' => 'Numverify API সফলভাবে কাজ করছে! ✅']);
            }
            return response()->json(['success' => false, 'message' => 'Numverify কী (Key) ইনভ্যালিড।']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function testPokeAPI(Request $request)
    {
        try {
            $response = Http::get('https://pokeapi.co/api/v2/pokemon/ditto');
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'PokéAPI কানেকশন সফল! ✅ (এটি একটি ফ্রি এপিআই)']);
            }
            return response()->json(['success' => false, 'message' => 'PokéAPI সার্ভার রেসপন্স করছে না।']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    }

    public function update(Request $request)
    {
        $data = $request->except(['_token', '_method']);

        foreach ($data as $key => $value) {
            // Determine group based on key prefix or predefined list
            $group = $this->determineGroup($key);
            
            AppSetting::set($key, $value, $group);
        }

        return redirect()->back()->with('success', 'Settings updated successfully.');
    }

    private function determineGroup($key)
    {
        if (str_starts_with($key, 'mail_')) return 'mail';
        if (str_starts_with($key, 'sms_')) return 'sms';
        if (str_starts_with($key, 'payment_')) return 'payment';
        if (str_starts_with($key, 'sslcommerz_')) return 'payment';
        if (str_starts_with($key, 'bkash_')) return 'payment';
        if (str_starts_with($key, 'nagad_')) return 'payment';
        if (str_starts_with($key, 'rocket_')) return 'payment';
        if (str_starts_with($key, 'enable_sslcommerz')) return 'payment';
        if (str_starts_with($key, 'enable_bkash')) return 'payment';
        if (str_starts_with($key, 'enable_nagad')) return 'payment';
        if (str_starts_with($key, 'enable_rocket')) return 'payment';
        if (str_starts_with($key, 'site_')) return 'site';
        if (str_starts_with($key, 'theme_')) return 'theme';
        if (str_starts_with($key, 'ai_')) return 'ai';
        if (str_starts_with($key, 'api_')) return 'external_api';
        return 'general';
    }
}
