<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SecuritySetting;
use Illuminate\Http\Request;

class SecuritySettingController extends Controller
{
    public function index()
    {
        $settings = SecuritySetting::firstOrCreate([], [
            'enable_captcha' => false,
            'enable_2fa' => false,
            'enable_ip_blocking' => false,
            'enable_honeypot' => false,
            'enable_login_log' => false,
            'enable_data_backup' => false,
            'enable_maintenance_mode' => false,
        ]);

        return view('admin.security.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $settings = SecuritySetting::first();
        
        // Handle checkbox values (if unchecked, they are not present in request)
        $data = [
            'enable_captcha' => $request->has('enable_captcha'),
            'enable_2fa' => $request->has('enable_2fa'),
            'enable_ip_blocking' => $request->has('enable_ip_blocking'),
            'enable_honeypot' => $request->has('enable_honeypot'),
            'enable_login_log' => $request->has('enable_login_log'),
            'enable_data_backup' => $request->has('enable_data_backup'),
            'enable_maintenance_mode' => $request->has('enable_maintenance_mode'),
        ];

        $settings->update($data);

        return redirect()->back()->with('success', 'Security settings updated successfully.');
    }
}
