<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BlockedIp;
use Illuminate\Http\Request;

class BlockedIpController extends Controller
{
    public function index()
    {
        $blockedIps = BlockedIp::latest()->paginate(10);
        return view('admin.security.blocked-ips', compact('blockedIps'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'ip_address' => 'required|ip|unique:blocked_ips,ip_address',
            'reason' => 'nullable|string|max:255',
        ]);

        BlockedIp::create($request->all());

        return redirect()->back()->with('success', 'IP Address blocked successfully.');
    }

    public function destroy($id)
    {
        BlockedIp::findOrFail($id)->delete();
        return redirect()->back()->with('success', 'IP Address unblocked successfully.');
    }
}
