<?php

namespace App\Http\Controllers\API\Tenant;

use App\Http\Controllers\Controller;
use App\Models\Tenant\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index(Request $request)
    {
        $categories = Category::whereNull('parent_id')->get(['id', 'name']);
        return response()->json($categories);
    }

    public function subcategories(Request $request, $parentId)
    {
        $subcategories = Category::where('parent_id', $parentId)->get(['id', 'name']);
        return response()->json($subcategories);
    }
}
