<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        $menu = [];

        if ($user->hasRole('Admin')) {
            $menu = [
                ['label' => 'Dashboard', 'route' => '/dashboard'],
                ['label' => 'Tenants', 'route' => '/admin/tenants'],
                ['label' => 'Users', 'route' => '/admin/users'],
                ['label' => 'Subscriptions', 'route' => '/admin/subscriptions'],
            ];
        } elseif ($user->hasRole('Manager')) {
            $menu = [
                ['label' => 'Dashboard', 'route' => '/dashboard'],
                ['label' => 'POS', 'route' => '/pos'],
                ['label' => 'Products', 'route' => '/products'],
                ['label' => 'Sales', 'route' => '/sales'],
                ['label' => 'Inventory', 'route' => '/inventory'],
                ['label' => 'Billing', 'route' => '/billing'],
            ];
        } else {
            // Staff
            $menu = [
                ['label' => 'POS', 'route' => '/pos'],
            ];
        }

        return response()->json($menu);
    }
}
