<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Tenant;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;

class MigrateSpecificTenant extends Command
{
    protected $signature = 'tenant:migrate-specific {id}';
    protected $description = 'Run migrations for a specific tenant by ID';

    public function handle()
    {
        $id = $this->argument('id');
        $tenant = Tenant::find($id);
        
        if (!$tenant) {
            $this->error("No tenant found with ID {$id}!");
            return;
        }

        $this->info("Migrating database for tenant: {$tenant->name} ({$tenant->database_name})");

        // Switch DB
        Config::set('database.connections.tenant.database', $tenant->database_name);
        DB::purge('tenant');
        DB::reconnect('tenant');
        
        // Run migration
        Artisan::call('migrate', [
            '--path' => 'database/migrations/tenant',
            '--database' => 'tenant',
            '--force' => true,
        ]);

        $this->info(Artisan::output());
    }
}
