### [2026-02-03] Step 63: Stock In UI/UX Overhaul & Functional Improvements
- **Author**: AI Agent
- **Description**:
  - **Task**: Revise Stock In header layout, fix product loading issues, resolve Select2/jQuery conflicts, and implement MRR functionality.
  - **Action**:
    - **Header Layout**:
        - Redesigned header to a 1-row/5-column layout (Location | Supplier | MRR No | Challan No | Attachment) with vertical separators (`divide-x`).
    - **Select2 & Product Search**:
        - Implemented **Per-Element Select2 Initialization** to fix loading issues in dynamically added rows.
        - Rewrote `searchProducts` controller method to query `ProductVariant` directly for better performance and accuracy.
        - Added dynamic display text handling for products/variants (e.g., "Product Name - Variant Name (SKU)").
        - Configured Select2 with `minimumInputLength: 0` to allow loading latest products on empty search.
    - **Bug Fixes**:
        - Resolved `Uncaught ReferenceError: jQuery is not defined` and `Uncaught TypeError: jQuery(...).select2 is not a function` by moving jQuery/Select2 scripts to the end of the `body` tag and ensuring global availability.
        - Replaced all `$` references with `jQuery` in `in.blade.php` to avoid conflicts.
        - Fixed "Add Another Item" functionality by ensuring `initProductSelect2` is called for new rows.
        - Corrected SVG path commands in "Remove Item" buttons (added missing 'M' command).
    - **MRR Functionality**:
        - Added `searchMrrs` method and route for searching existing MRRs.
        - Implemented "View Report" and "Print PDF" buttons with auto-print capability via `window.print()`.
    - **Functional Updates**:
        - Made **Location field optional (nullable)** in Stock In form and controller validation.
        - Fixed SQL Error: Changed `product_variant_id` to `variant_id` and `unit_cost` to `cost` in `PurchaseItem` creation logic.
        - Fixed SQL Error: Removed `product_id` from `StockMovement` creation in `store` method to match database schema.
        - Fixed Relationship Error: Added missing relationships (`location`, `brand`, `manufacturer`, `unit`) to `PurchaseItem` model.
        - Fixed MRR Search: Improved `searchMrrs` logic to include `purchase_no` and eager load suppliers for better search results.
    - **Technical Improvements**:
        - Used `DB::connection('tenant')->beginTransaction()` for transactional integrity during stock-in.
        - Added `checkJQuery` function to safely initialize the page only after jQuery/Select2 are fully loaded.
